package Interface;

import java.awt.*;
import java.applet.*;
import java.net.*;

/**
 * A simple demonstration applet for the Scenix HTTP virtual peripheral.
 * <p>
 * A sprinkler controller applet. By changing the applet controls the user
 * can alter variables in the SX which could, in a real application, be used
 * to turn on or off a garden sprinkler.
 * <p>
 * UDP is used to communicate the settings to and from the SX. Using this applet
 * and UDP rather than HTTP forms and POST events moves the programming burden
 * from SX assembly language to Java. This allows much more sophisticated
 * interfaces and shorter development time.
 *
 * @author      Chris Waters
 * @version     1.0, 12/10/99
 */


public class SXControls extends Applet {

  final static int COMMAND_GET = 10; // Get values from the SX.
  final static int COMMAND_SET = 11; // Set values on the SX.

  final static String SX_ADDRESS = "sx"; // IP address or name of the SX. 
  final static int SX_PORT = 7024; // Port to send to and listen on.

  GridLayout gridLayout1;

  String zones[] = {"Front Lawn","Pathway","Flower Bed"};

  Label labels[];
  Checkbox onBox[];
  Choice onTime[];

  Button send = new Button();

  public void init() {
    try {
      jbInit();
      readValues();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* Packet format:

     byte command
     byte numZones
     byte zone1On
     byte zone1Time
     byte zone2On
     byte zone2Time
     ...

  */

  void readValues() {
    byte data[] = {COMMAND_GET};
    byte buffer[] = new byte[256];

    try {
      System.out.println("Reading values");
      DatagramPacket packet = null;
      InetAddress address = InetAddress.getByName(SX_ADDRESS);
      packet = new DatagramPacket(data, data.length, address, SX_PORT);
      DatagramSocket socket = new DatagramSocket();
      socket.send(packet);

      packet = new DatagramPacket(buffer, buffer.length);
      System.out.println("Listening on port " + String.valueOf(socket.getLocalPort()));
      try {
	  socket.receive(packet);
	}
	catch (SocketException e) {
	  // This is to work around a bug in Netscape 4.0.
	  socket.receive(packet);
	}
      socket.close();

      byte rxData[] = packet.getData();

      System.out.println("Got a packet");
      System.out.println(rxData.toString());

      for ( int i = 0; i < Math.min(rxData[1],zones.length); i++ ) {
        onBox[i].setState(rxData[2+i*2]!=0);
        if ( rxData[3+i*2] < onTime[i].countItems() )
          onTime[i].select( rxData[3+i*2] );
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  void writeValues() {
    byte data[] = new byte[2+zones.length*2];

    data[0] = COMMAND_SET;
    data[1] = (byte)zones.length;
    for ( int i = 0; i < zones.length; i++ ) {
      data[2 + i*2] = (byte)(onBox[i].getState()?1:0);
      data[3 + i*2] = (byte)onTime[i].getSelectedIndex();
    }

    try {
      System.out.println("Sending values");
      InetAddress address = InetAddress.getByName(SX_ADDRESS);
      DatagramPacket packet = new DatagramPacket(data, data.length, address, SX_PORT);
      DatagramSocket socket = new DatagramSocket();
      socket.send(packet);
      socket.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  public boolean action(Event e, Object arg) {
    if ( e.target == send ) {
      writeValues();
      return true;
    }
    else
      return false;
  }

  void jbInit() throws Exception {
    this.setBackground(Color.lightGray);

    gridLayout1 = new GridLayout(zones.length+1,3);
    this.setLayout(gridLayout1);

    labels = new Label[zones.length];
    onBox = new Checkbox[zones.length];
    onTime = new Choice[zones.length];

    for ( int i = 0; i < zones.length; i++ ) {
      labels[i] = new Label();
      labels[i].setText(zones[i]);
      onBox[i] = new Checkbox();
      onBox[i].setLabel("On");
      onTime[i] = new Choice();
      onTime[i].addItem("15 minutes");
      onTime[i].addItem("30 minutes");
      onTime[i].addItem("45 minutes");

      this.add(labels[i]);
      this.add(onBox[i]);
      this.add(onTime[i]);
    }

    send.setLabel("Update");
    this.add(send);
  }
}

